<?php
global $pdo, $sliderData, $GAMES;
?>
<!-- HOME / LOBBY -->
<div id="home-view">
    <!-- Slider -->
    <div class="slider-container" id="main-slider">
        <?php foreach ($sliderData as $index => $slide): ?>
        <img src="<?php echo $slide['img']; ?>" class="slider-img <?php echo $index === 0 ? 'active' : ''; ?>" 
             onclick="window.location.href='<?php echo $slide['link']; ?>'">
        <?php endforeach; ?>
    </div>

    <div class="section-header">
        <i class="fas fa-fire-alt fire-icon"></i>
        <h3>Original Games</h3>
    </div>

    <!-- WIN GO GAMES -->
    <div class="game-grid">
        <?php foreach ($GAMES as $key => $game): ?>
        <div class="game-card" onclick="openGame('<?php echo $key; ?>')">
            <img src="ball_<?php echo rand(10, 15); ?>.webp" alt="<?php echo $key; ?>">
            <div class="card-overlay">
                <h4><?php echo $game['name']; ?></h4>
                <span>Guess Number</span>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <!-- THIRD PARTY GAMES -->
    <div class="section-header" style="margin-top: 20px;">
        <i class="fas fa-gamepad fire-icon text-blue"></i>
        <h3>Partner Games</h3>
    </div>
    
    <div class="partner-game-grid" id="partner-grid-container">
        <!-- JS will populate 50+ items here -->
    </div>
</div>